//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			:
//****************************************** 
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"

// this example is used to test the IO speed of 6821
// when system clock is 16MHz, the maximum speed that can be run is 0.25us
// output a square wave from P72 and P40, and change the clock source to see if the frequency of square wave changes


delay()
{
	uchar	temp=0;
	while(temp<20){temp++;clr_wdt;}
}


// please note that to change the frequency of the high-frequency clock (fosc), it is necessary to do it in SLOW1 mode.

void main()
{
	__asm("DI");
		
	fssel=0;	// select internal low-frequency clock as low-frequency clock source
	xten=1;	// start internal low-frequency clock oscillation
	delay();	// wait for internal low-frequency clock stable
	sysck=1;	// select low-frequency clock as system clock
	oscen=0;	// disable internal high-frequency clock
	
//================================================================

//16MHz (default)
	
	FSCTRL.bit.b2=0;
	FSCTRL.bit.b1=0;	//00 8m  ,   01 16m
	
	oscen=1;	// enable internal high-frequency clock	
	delay();	// wait for internal high-frequency clock stable
	oscsel=0;	// select internal high-frequency clock as reference
	sysck=0;	// select internal high-frequency clock as system clock
	xten=0;	// disable internal low-frequency clock
//	fc_div_8;

//============================================================================================
// enable PPG function for easy testing
// output PPG from P72


	P7FC.bit.b2	= 1;
	P7CR.bit.b2 = 1;
//	__asm("DI");
    POFFCR0.byte = 0x1;
//	__asm("EI");
	TA0CR.byte = 0x40; //no IntTCA0,FF=1,no noise canceller,continue mode
	TA0MOD.byte = 0x9b;//double buffer,source clock=fcgck/2^10,PPG output mode
	TA0DRAL.byte= 0x0;
	TA0DRAH.byte= 0x20;	//set output period
	TA0DRBL.byte = 0x0;
	TA0DRBH.byte = 0x10;	//set pulse width
	TA0CR.bit.b0 = 1;//start Timer Counter
	
	
	

// enable PPG function for easy testing
//============================================================================================

	__asm("EI");
	
	P2CR.byte=0xff;
	
while(1)
	{
	clr_wdt;
		
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
		

	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;
		

	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;	
	p40=1;
	p40=0;
		
		
		
		
		
		
		
	}
}